#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_6fc7e4d4-50ee-4d58-852f-0b69c73169db_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-6fc7e4d4-50ee-4d58-852f-0b69c73169db.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-6fc7e4d4-50ee-4d58-852f-0b69c73169db.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['6fc7e4d4-50ee-4d58-852f-0b69c73169db']['InstallationDir']}/service-6fc7e4d4-50ee-4d58-852f-0b69c73169db.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-6fc7e4d4-50ee-4d58-852f-0b69c73169db.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['6fc7e4d4-50ee-4d58-852f-0b69c73169db']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['6fc7e4d4-50ee-4d58-852f-0b69c73169db']['InstallationDir']}/service-6fc7e4d4-50ee-4d58-852f-0b69c73169db.jar" do
  		source "#{node['CHOReOSData']['serviceData']['6fc7e4d4-50ee-4d58-852f-0b69c73169db']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_6fc7e4d4-50ee-4d58-852f-0b69c73169db_jar]"
		notifies :start, "service[service_6fc7e4d4-50ee-4d58-852f-0b69c73169db_jar]"
	end
end

if node['CHOReOSData']['serviceData']['6fc7e4d4-50ee-4d58-852f-0b69c73169db']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['6fc7e4d4-50ee-4d58-852f-0b69c73169db']['InstallationDir']}/service-6fc7e4d4-50ee-4d58-852f-0b69c73169db.jar" do
		notifies :stop, "service[service_6fc7e4d4-50ee-4d58-852f-0b69c73169db_jar]", :immediately
		#notifies :disable, "service[service_6fc7e4d4-50ee-4d58-852f-0b69c73169db_jar]", :immediately
		action :delete
	end
end