#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_7011fa0a-3257-4d54-a642-4d48058be4ee_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-7011fa0a-3257-4d54-a642-4d48058be4ee.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-7011fa0a-3257-4d54-a642-4d48058be4ee.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['7011fa0a-3257-4d54-a642-4d48058be4ee']['InstallationDir']}/service-7011fa0a-3257-4d54-a642-4d48058be4ee.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-7011fa0a-3257-4d54-a642-4d48058be4ee.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['7011fa0a-3257-4d54-a642-4d48058be4ee']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['7011fa0a-3257-4d54-a642-4d48058be4ee']['InstallationDir']}/service-7011fa0a-3257-4d54-a642-4d48058be4ee.jar" do
  		source "#{node['CHOReOSData']['serviceData']['7011fa0a-3257-4d54-a642-4d48058be4ee']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_7011fa0a-3257-4d54-a642-4d48058be4ee_jar]"
		notifies :start, "service[service_7011fa0a-3257-4d54-a642-4d48058be4ee_jar]"
	end
end

if node['CHOReOSData']['serviceData']['7011fa0a-3257-4d54-a642-4d48058be4ee']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['7011fa0a-3257-4d54-a642-4d48058be4ee']['InstallationDir']}/service-7011fa0a-3257-4d54-a642-4d48058be4ee.jar" do
		notifies :stop, "service[service_7011fa0a-3257-4d54-a642-4d48058be4ee_jar]", :immediately
		#notifies :disable, "service[service_7011fa0a-3257-4d54-a642-4d48058be4ee_jar]", :immediately
		action :delete
	end
end