#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_759906df-8b71-46bc-be14-364cc26b42fb_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-759906df-8b71-46bc-be14-364cc26b42fb.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-759906df-8b71-46bc-be14-364cc26b42fb.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['759906df-8b71-46bc-be14-364cc26b42fb']['InstallationDir']}/service-759906df-8b71-46bc-be14-364cc26b42fb.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-759906df-8b71-46bc-be14-364cc26b42fb.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['759906df-8b71-46bc-be14-364cc26b42fb']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['759906df-8b71-46bc-be14-364cc26b42fb']['InstallationDir']}/service-759906df-8b71-46bc-be14-364cc26b42fb.jar" do
  		source "#{node['CHOReOSData']['serviceData']['759906df-8b71-46bc-be14-364cc26b42fb']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_759906df-8b71-46bc-be14-364cc26b42fb_jar]"
		notifies :start, "service[service_759906df-8b71-46bc-be14-364cc26b42fb_jar]"
	end
end

if node['CHOReOSData']['serviceData']['759906df-8b71-46bc-be14-364cc26b42fb']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['759906df-8b71-46bc-be14-364cc26b42fb']['InstallationDir']}/service-759906df-8b71-46bc-be14-364cc26b42fb.jar" do
		notifies :stop, "service[service_759906df-8b71-46bc-be14-364cc26b42fb_jar]", :immediately
		#notifies :disable, "service[service_759906df-8b71-46bc-be14-364cc26b42fb_jar]", :immediately
		action :delete
	end
end