#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_7d627a2e-c994-4027-ba6f-16947def029a_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service7d627a2e-c994-4027-ba6f-16947def029aDeploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['7d627a2e-c994-4027-ba6f-16947def029a']['installationDir']}/service7d627a2e-c994-4027-ba6f-16947def029aDeploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service7d627a2e-c994-4027-ba6f-16947def029aDeploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['7d627a2e-c994-4027-ba6f-16947def029a']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['7d627a2e-c994-4027-ba6f-16947def029a']['InstallationDir']}/service7d627a2e-c994-4027-ba6f-16947def029aDeploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['7d627a2e-c994-4027-ba6f-16947def029a']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_7d627a2e-c994-4027-ba6f-16947def029a_jar]"
		notifies :start, "service[service_7d627a2e-c994-4027-ba6f-16947def029a_jar]"
	end
end

if node['CHOReOSData']['serviceData']['7d627a2e-c994-4027-ba6f-16947def029a']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['7d627a2e-c994-4027-ba6f-16947def029a']['InstallationDir']}/service7d627a2e-c994-4027-ba6f-16947def029aDeploy.jar" do
		notifies :stop, "service[service_7d627a2e-c994-4027-ba6f-16947def029a_jar]", :immediately
		#notifies :disable, "service[service_7d627a2e-c994-4027-ba6f-16947def029a_jar]", :immediately
		action :delete
	end
end