#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_7e4d3332-09c6-4198-ab8d-41299b0f0b43_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service7e4d3332-09c6-4198-ab8d-41299b0f0b43Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['7e4d3332-09c6-4198-ab8d-41299b0f0b43']['installationDir']}/service7e4d3332-09c6-4198-ab8d-41299b0f0b43Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service7e4d3332-09c6-4198-ab8d-41299b0f0b43Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['7e4d3332-09c6-4198-ab8d-41299b0f0b43']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['7e4d3332-09c6-4198-ab8d-41299b0f0b43']['InstallationDir']}/service7e4d3332-09c6-4198-ab8d-41299b0f0b43Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['7e4d3332-09c6-4198-ab8d-41299b0f0b43']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_7e4d3332-09c6-4198-ab8d-41299b0f0b43_jar]"
		notifies :start, "service[service_7e4d3332-09c6-4198-ab8d-41299b0f0b43_jar]"
	end
end

if node['CHOReOSData']['serviceData']['7e4d3332-09c6-4198-ab8d-41299b0f0b43']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['7e4d3332-09c6-4198-ab8d-41299b0f0b43']['InstallationDir']}/service7e4d3332-09c6-4198-ab8d-41299b0f0b43Deploy.jar" do
		notifies :stop, "service[service_7e4d3332-09c6-4198-ab8d-41299b0f0b43_jar]", :immediately
		#notifies :disable, "service[service_7e4d3332-09c6-4198-ab8d-41299b0f0b43_jar]", :immediately
		action :delete
	end
end