#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_8292e713-dafb-4a8d-95c2-16da4faa2dce_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-8292e713-dafb-4a8d-95c2-16da4faa2dce.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-8292e713-dafb-4a8d-95c2-16da4faa2dce.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['8292e713-dafb-4a8d-95c2-16da4faa2dce']['InstallationDir']}/service-8292e713-dafb-4a8d-95c2-16da4faa2dce.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-8292e713-dafb-4a8d-95c2-16da4faa2dce.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['8292e713-dafb-4a8d-95c2-16da4faa2dce']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['8292e713-dafb-4a8d-95c2-16da4faa2dce']['InstallationDir']}/service-8292e713-dafb-4a8d-95c2-16da4faa2dce.jar" do
  		source "#{node['CHOReOSData']['serviceData']['8292e713-dafb-4a8d-95c2-16da4faa2dce']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_8292e713-dafb-4a8d-95c2-16da4faa2dce_jar]"
		notifies :start, "service[service_8292e713-dafb-4a8d-95c2-16da4faa2dce_jar]"
	end
end

if node['CHOReOSData']['serviceData']['8292e713-dafb-4a8d-95c2-16da4faa2dce']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['8292e713-dafb-4a8d-95c2-16da4faa2dce']['InstallationDir']}/service-8292e713-dafb-4a8d-95c2-16da4faa2dce.jar" do
		notifies :stop, "service[service_8292e713-dafb-4a8d-95c2-16da4faa2dce_jar]", :immediately
		#notifies :disable, "service[service_8292e713-dafb-4a8d-95c2-16da4faa2dce_jar]", :immediately
		action :delete
	end
end