#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_8e4b5edb-554f-45ac-9231-ae4e7f6cff13_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service8e4b5edb-554f-45ac-9231-ae4e7f6cff13Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['8e4b5edb-554f-45ac-9231-ae4e7f6cff13']['installationDir']}/service8e4b5edb-554f-45ac-9231-ae4e7f6cff13Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service8e4b5edb-554f-45ac-9231-ae4e7f6cff13Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['8e4b5edb-554f-45ac-9231-ae4e7f6cff13']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['8e4b5edb-554f-45ac-9231-ae4e7f6cff13']['InstallationDir']}/service8e4b5edb-554f-45ac-9231-ae4e7f6cff13Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['8e4b5edb-554f-45ac-9231-ae4e7f6cff13']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_8e4b5edb-554f-45ac-9231-ae4e7f6cff13_jar]"
		notifies :start, "service[service_8e4b5edb-554f-45ac-9231-ae4e7f6cff13_jar]"
	end
end

if node['CHOReOSData']['serviceData']['8e4b5edb-554f-45ac-9231-ae4e7f6cff13']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['8e4b5edb-554f-45ac-9231-ae4e7f6cff13']['InstallationDir']}/service8e4b5edb-554f-45ac-9231-ae4e7f6cff13Deploy.jar" do
		notifies :stop, "service[service_8e4b5edb-554f-45ac-9231-ae4e7f6cff13_jar]", :immediately
		#notifies :disable, "service[service_8e4b5edb-554f-45ac-9231-ae4e7f6cff13_jar]", :immediately
		action :delete
	end
end