#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_93499d47-7134-4054-a448-20621170e822_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-93499d47-7134-4054-a448-20621170e822.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-93499d47-7134-4054-a448-20621170e822.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['93499d47-7134-4054-a448-20621170e822']['InstallationDir']}/service-93499d47-7134-4054-a448-20621170e822.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-93499d47-7134-4054-a448-20621170e822.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['93499d47-7134-4054-a448-20621170e822']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['93499d47-7134-4054-a448-20621170e822']['InstallationDir']}/service-93499d47-7134-4054-a448-20621170e822.jar" do
  		source "#{node['CHOReOSData']['serviceData']['93499d47-7134-4054-a448-20621170e822']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_93499d47-7134-4054-a448-20621170e822_jar]"
		notifies :start, "service[service_93499d47-7134-4054-a448-20621170e822_jar]"
	end
end

if node['CHOReOSData']['serviceData']['93499d47-7134-4054-a448-20621170e822']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['93499d47-7134-4054-a448-20621170e822']['InstallationDir']}/service-93499d47-7134-4054-a448-20621170e822.jar" do
		notifies :stop, "service[service_93499d47-7134-4054-a448-20621170e822_jar]", :immediately
		#notifies :disable, "service[service_93499d47-7134-4054-a448-20621170e822_jar]", :immediately
		action :delete
	end
end