#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_999f1b2d-d10c-4847-aa7c-3583d434b7ae_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-999f1b2d-d10c-4847-aa7c-3583d434b7ae.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-999f1b2d-d10c-4847-aa7c-3583d434b7ae.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['999f1b2d-d10c-4847-aa7c-3583d434b7ae']['InstallationDir']}/service-999f1b2d-d10c-4847-aa7c-3583d434b7ae.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-999f1b2d-d10c-4847-aa7c-3583d434b7ae.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['999f1b2d-d10c-4847-aa7c-3583d434b7ae']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['999f1b2d-d10c-4847-aa7c-3583d434b7ae']['InstallationDir']}/service-999f1b2d-d10c-4847-aa7c-3583d434b7ae.jar" do
  		source "#{node['CHOReOSData']['serviceData']['999f1b2d-d10c-4847-aa7c-3583d434b7ae']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_999f1b2d-d10c-4847-aa7c-3583d434b7ae_jar]"
		notifies :start, "service[service_999f1b2d-d10c-4847-aa7c-3583d434b7ae_jar]"
	end
end

if node['CHOReOSData']['serviceData']['999f1b2d-d10c-4847-aa7c-3583d434b7ae']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['999f1b2d-d10c-4847-aa7c-3583d434b7ae']['InstallationDir']}/service-999f1b2d-d10c-4847-aa7c-3583d434b7ae.jar" do
		notifies :stop, "service[service_999f1b2d-d10c-4847-aa7c-3583d434b7ae_jar]", :immediately
		#notifies :disable, "service[service_999f1b2d-d10c-4847-aa7c-3583d434b7ae_jar]", :immediately
		action :delete
	end
end