#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb']['InstallationDir']}/service-9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb']['InstallationDir']}/service-9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb.jar" do
  		source "#{node['CHOReOSData']['serviceData']['9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb_jar]"
		notifies :start, "service[service_9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb_jar]"
	end
end

if node['CHOReOSData']['serviceData']['9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb']['InstallationDir']}/service-9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb.jar" do
		notifies :stop, "service[service_9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb_jar]", :immediately
		#notifies :disable, "service[service_9c5ebf59-97ee-44ab-a9a7-b1e9abb0fccb_jar]", :immediately
		action :delete
	end
end