#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_9e236a60-e455-4ec3-8048-91adf38404fc_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-9e236a60-e455-4ec3-8048-91adf38404fc.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-9e236a60-e455-4ec3-8048-91adf38404fc.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['9e236a60-e455-4ec3-8048-91adf38404fc']['InstallationDir']}/service-9e236a60-e455-4ec3-8048-91adf38404fc.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-9e236a60-e455-4ec3-8048-91adf38404fc.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['9e236a60-e455-4ec3-8048-91adf38404fc']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['9e236a60-e455-4ec3-8048-91adf38404fc']['InstallationDir']}/service-9e236a60-e455-4ec3-8048-91adf38404fc.jar" do
  		source "#{node['CHOReOSData']['serviceData']['9e236a60-e455-4ec3-8048-91adf38404fc']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_9e236a60-e455-4ec3-8048-91adf38404fc_jar]"
		notifies :start, "service[service_9e236a60-e455-4ec3-8048-91adf38404fc_jar]"
	end
end

if node['CHOReOSData']['serviceData']['9e236a60-e455-4ec3-8048-91adf38404fc']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['9e236a60-e455-4ec3-8048-91adf38404fc']['InstallationDir']}/service-9e236a60-e455-4ec3-8048-91adf38404fc.jar" do
		notifies :stop, "service[service_9e236a60-e455-4ec3-8048-91adf38404fc_jar]", :immediately
		#notifies :disable, "service[service_9e236a60-e455-4ec3-8048-91adf38404fc_jar]", :immediately
		action :delete
	end
end