#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_a3f6870a-6c69-4669-8b32-e9190a367b87_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-a3f6870a-6c69-4669-8b32-e9190a367b87.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-a3f6870a-6c69-4669-8b32-e9190a367b87.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['a3f6870a-6c69-4669-8b32-e9190a367b87']['InstallationDir']}/service-a3f6870a-6c69-4669-8b32-e9190a367b87.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-a3f6870a-6c69-4669-8b32-e9190a367b87.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['a3f6870a-6c69-4669-8b32-e9190a367b87']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['a3f6870a-6c69-4669-8b32-e9190a367b87']['InstallationDir']}/service-a3f6870a-6c69-4669-8b32-e9190a367b87.jar" do
  		source "#{node['CHOReOSData']['serviceData']['a3f6870a-6c69-4669-8b32-e9190a367b87']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_a3f6870a-6c69-4669-8b32-e9190a367b87_jar]"
		notifies :start, "service[service_a3f6870a-6c69-4669-8b32-e9190a367b87_jar]"
	end
end

if node['CHOReOSData']['serviceData']['a3f6870a-6c69-4669-8b32-e9190a367b87']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['a3f6870a-6c69-4669-8b32-e9190a367b87']['InstallationDir']}/service-a3f6870a-6c69-4669-8b32-e9190a367b87.jar" do
		notifies :stop, "service[service_a3f6870a-6c69-4669-8b32-e9190a367b87_jar]", :immediately
		#notifies :disable, "service[service_a3f6870a-6c69-4669-8b32-e9190a367b87_jar]", :immediately
		action :delete
	end
end