#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_a7cb9e32-90d8-494c-b29d-9930c856f758_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/servicea7cb9e32-90d8-494c-b29d-9930c856f758Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['a7cb9e32-90d8-494c-b29d-9930c856f758']['installationDir']}/servicea7cb9e32-90d8-494c-b29d-9930c856f758Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/servicea7cb9e32-90d8-494c-b29d-9930c856f758Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['a7cb9e32-90d8-494c-b29d-9930c856f758']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['a7cb9e32-90d8-494c-b29d-9930c856f758']['InstallationDir']}/servicea7cb9e32-90d8-494c-b29d-9930c856f758Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['a7cb9e32-90d8-494c-b29d-9930c856f758']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_a7cb9e32-90d8-494c-b29d-9930c856f758_jar]"
		notifies :start, "service[service_a7cb9e32-90d8-494c-b29d-9930c856f758_jar]"
	end
end

if node['CHOReOSData']['serviceData']['a7cb9e32-90d8-494c-b29d-9930c856f758']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['a7cb9e32-90d8-494c-b29d-9930c856f758']['InstallationDir']}/servicea7cb9e32-90d8-494c-b29d-9930c856f758Deploy.jar" do
		notifies :stop, "service[service_a7cb9e32-90d8-494c-b29d-9930c856f758_jar]", :immediately
		#notifies :disable, "service[service_a7cb9e32-90d8-494c-b29d-9930c856f758_jar]", :immediately
		action :delete
	end
end