#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_a94fb19a-90c9-434e-a6e0-e06ba9945b2a_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-a94fb19a-90c9-434e-a6e0-e06ba9945b2a.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-a94fb19a-90c9-434e-a6e0-e06ba9945b2a.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['a94fb19a-90c9-434e-a6e0-e06ba9945b2a']['InstallationDir']}/service-a94fb19a-90c9-434e-a6e0-e06ba9945b2a.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-a94fb19a-90c9-434e-a6e0-e06ba9945b2a.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['a94fb19a-90c9-434e-a6e0-e06ba9945b2a']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['a94fb19a-90c9-434e-a6e0-e06ba9945b2a']['InstallationDir']}/service-a94fb19a-90c9-434e-a6e0-e06ba9945b2a.jar" do
  		source "#{node['CHOReOSData']['serviceData']['a94fb19a-90c9-434e-a6e0-e06ba9945b2a']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_a94fb19a-90c9-434e-a6e0-e06ba9945b2a_jar]"
		notifies :start, "service[service_a94fb19a-90c9-434e-a6e0-e06ba9945b2a_jar]"
	end
end

if node['CHOReOSData']['serviceData']['a94fb19a-90c9-434e-a6e0-e06ba9945b2a']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['a94fb19a-90c9-434e-a6e0-e06ba9945b2a']['InstallationDir']}/service-a94fb19a-90c9-434e-a6e0-e06ba9945b2a.jar" do
		notifies :stop, "service[service_a94fb19a-90c9-434e-a6e0-e06ba9945b2a_jar]", :immediately
		#notifies :disable, "service[service_a94fb19a-90c9-434e-a6e0-e06ba9945b2a_jar]", :immediately
		action :delete
	end
end