#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_a9849e5b-4d0e-41ea-8f62-79f0d0565c1d_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-a9849e5b-4d0e-41ea-8f62-79f0d0565c1d.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-a9849e5b-4d0e-41ea-8f62-79f0d0565c1d.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['a9849e5b-4d0e-41ea-8f62-79f0d0565c1d']['InstallationDir']}/service-a9849e5b-4d0e-41ea-8f62-79f0d0565c1d.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-a9849e5b-4d0e-41ea-8f62-79f0d0565c1d.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['a9849e5b-4d0e-41ea-8f62-79f0d0565c1d']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['a9849e5b-4d0e-41ea-8f62-79f0d0565c1d']['InstallationDir']}/service-a9849e5b-4d0e-41ea-8f62-79f0d0565c1d.jar" do
  		source "#{node['CHOReOSData']['serviceData']['a9849e5b-4d0e-41ea-8f62-79f0d0565c1d']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_a9849e5b-4d0e-41ea-8f62-79f0d0565c1d_jar]"
		notifies :start, "service[service_a9849e5b-4d0e-41ea-8f62-79f0d0565c1d_jar]"
	end
end

if node['CHOReOSData']['serviceData']['a9849e5b-4d0e-41ea-8f62-79f0d0565c1d']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['a9849e5b-4d0e-41ea-8f62-79f0d0565c1d']['InstallationDir']}/service-a9849e5b-4d0e-41ea-8f62-79f0d0565c1d.jar" do
		notifies :stop, "service[service_a9849e5b-4d0e-41ea-8f62-79f0d0565c1d_jar]", :immediately
		#notifies :disable, "service[service_a9849e5b-4d0e-41ea-8f62-79f0d0565c1d_jar]", :immediately
		action :delete
	end
end