#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_aa9d2568-d131-469b-8206-8920088dc011_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-aa9d2568-d131-469b-8206-8920088dc011.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-aa9d2568-d131-469b-8206-8920088dc011.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['aa9d2568-d131-469b-8206-8920088dc011']['InstallationDir']}/service-aa9d2568-d131-469b-8206-8920088dc011.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-aa9d2568-d131-469b-8206-8920088dc011.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['aa9d2568-d131-469b-8206-8920088dc011']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['aa9d2568-d131-469b-8206-8920088dc011']['InstallationDir']}/service-aa9d2568-d131-469b-8206-8920088dc011.jar" do
  		source "#{node['CHOReOSData']['serviceData']['aa9d2568-d131-469b-8206-8920088dc011']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_aa9d2568-d131-469b-8206-8920088dc011_jar]"
		notifies :start, "service[service_aa9d2568-d131-469b-8206-8920088dc011_jar]"
	end
end

if node['CHOReOSData']['serviceData']['aa9d2568-d131-469b-8206-8920088dc011']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['aa9d2568-d131-469b-8206-8920088dc011']['InstallationDir']}/service-aa9d2568-d131-469b-8206-8920088dc011.jar" do
		notifies :stop, "service[service_aa9d2568-d131-469b-8206-8920088dc011_jar]", :immediately
		#notifies :disable, "service[service_aa9d2568-d131-469b-8206-8920088dc011_jar]", :immediately
		action :delete
	end
end