#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ae342a77-cfca-4311-bfe5-2fb64ac8e472_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/serviceae342a77-cfca-4311-bfe5-2fb64ac8e472Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['ae342a77-cfca-4311-bfe5-2fb64ac8e472']['installationDir']}/serviceae342a77-cfca-4311-bfe5-2fb64ac8e472Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/serviceae342a77-cfca-4311-bfe5-2fb64ac8e472Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ae342a77-cfca-4311-bfe5-2fb64ac8e472']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ae342a77-cfca-4311-bfe5-2fb64ac8e472']['InstallationDir']}/serviceae342a77-cfca-4311-bfe5-2fb64ac8e472Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ae342a77-cfca-4311-bfe5-2fb64ac8e472']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ae342a77-cfca-4311-bfe5-2fb64ac8e472_jar]"
		notifies :start, "service[service_ae342a77-cfca-4311-bfe5-2fb64ac8e472_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ae342a77-cfca-4311-bfe5-2fb64ac8e472']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ae342a77-cfca-4311-bfe5-2fb64ac8e472']['InstallationDir']}/serviceae342a77-cfca-4311-bfe5-2fb64ac8e472Deploy.jar" do
		notifies :stop, "service[service_ae342a77-cfca-4311-bfe5-2fb64ac8e472_jar]", :immediately
		#notifies :disable, "service[service_ae342a77-cfca-4311-bfe5-2fb64ac8e472_jar]", :immediately
		action :delete
	end
end