#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_bbb8c75f-872a-427e-9c8e-6054e1b3c178_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-bbb8c75f-872a-427e-9c8e-6054e1b3c178.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-bbb8c75f-872a-427e-9c8e-6054e1b3c178.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['bbb8c75f-872a-427e-9c8e-6054e1b3c178']['InstallationDir']}/service-bbb8c75f-872a-427e-9c8e-6054e1b3c178.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-bbb8c75f-872a-427e-9c8e-6054e1b3c178.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['bbb8c75f-872a-427e-9c8e-6054e1b3c178']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['bbb8c75f-872a-427e-9c8e-6054e1b3c178']['InstallationDir']}/service-bbb8c75f-872a-427e-9c8e-6054e1b3c178.jar" do
  		source "#{node['CHOReOSData']['serviceData']['bbb8c75f-872a-427e-9c8e-6054e1b3c178']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_bbb8c75f-872a-427e-9c8e-6054e1b3c178_jar]"
		notifies :start, "service[service_bbb8c75f-872a-427e-9c8e-6054e1b3c178_jar]"
	end
end

if node['CHOReOSData']['serviceData']['bbb8c75f-872a-427e-9c8e-6054e1b3c178']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['bbb8c75f-872a-427e-9c8e-6054e1b3c178']['InstallationDir']}/service-bbb8c75f-872a-427e-9c8e-6054e1b3c178.jar" do
		notifies :stop, "service[service_bbb8c75f-872a-427e-9c8e-6054e1b3c178_jar]", :immediately
		#notifies :disable, "service[service_bbb8c75f-872a-427e-9c8e-6054e1b3c178_jar]", :immediately
		action :delete
	end
end