#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0']['InstallationDir']}/service-c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0']['InstallationDir']}/service-c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0.jar" do
  		source "#{node['CHOReOSData']['serviceData']['c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0_jar]"
		notifies :start, "service[service_c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0_jar]"
	end
end

if node['CHOReOSData']['serviceData']['c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0']['InstallationDir']}/service-c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0.jar" do
		notifies :stop, "service[service_c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0_jar]", :immediately
		#notifies :disable, "service[service_c1a15fb5-281d-4fef-8f80-34a6d4dcc0c0_jar]", :immediately
		action :delete
	end
end