#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_c5c9fd06-7150-4e20-972b-6b9b2b795167_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/servicec5c9fd06-7150-4e20-972b-6b9b2b795167Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['c5c9fd06-7150-4e20-972b-6b9b2b795167']['installationDir']}/servicec5c9fd06-7150-4e20-972b-6b9b2b795167Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/servicec5c9fd06-7150-4e20-972b-6b9b2b795167Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['c5c9fd06-7150-4e20-972b-6b9b2b795167']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['c5c9fd06-7150-4e20-972b-6b9b2b795167']['InstallationDir']}/servicec5c9fd06-7150-4e20-972b-6b9b2b795167Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['c5c9fd06-7150-4e20-972b-6b9b2b795167']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_c5c9fd06-7150-4e20-972b-6b9b2b795167_jar]"
		notifies :start, "service[service_c5c9fd06-7150-4e20-972b-6b9b2b795167_jar]"
	end
end

if node['CHOReOSData']['serviceData']['c5c9fd06-7150-4e20-972b-6b9b2b795167']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['c5c9fd06-7150-4e20-972b-6b9b2b795167']['InstallationDir']}/servicec5c9fd06-7150-4e20-972b-6b9b2b795167Deploy.jar" do
		notifies :stop, "service[service_c5c9fd06-7150-4e20-972b-6b9b2b795167_jar]", :immediately
		#notifies :disable, "service[service_c5c9fd06-7150-4e20-972b-6b9b2b795167_jar]", :immediately
		action :delete
	end
end