#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ca02a235-7432-46fe-847a-8f5f5258ce73_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/serviceca02a235-7432-46fe-847a-8f5f5258ce73Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['ca02a235-7432-46fe-847a-8f5f5258ce73']['installationDir']}/serviceca02a235-7432-46fe-847a-8f5f5258ce73Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/serviceca02a235-7432-46fe-847a-8f5f5258ce73Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ca02a235-7432-46fe-847a-8f5f5258ce73']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ca02a235-7432-46fe-847a-8f5f5258ce73']['InstallationDir']}/serviceca02a235-7432-46fe-847a-8f5f5258ce73Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ca02a235-7432-46fe-847a-8f5f5258ce73']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ca02a235-7432-46fe-847a-8f5f5258ce73_jar]"
		notifies :start, "service[service_ca02a235-7432-46fe-847a-8f5f5258ce73_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ca02a235-7432-46fe-847a-8f5f5258ce73']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ca02a235-7432-46fe-847a-8f5f5258ce73']['InstallationDir']}/serviceca02a235-7432-46fe-847a-8f5f5258ce73Deploy.jar" do
		notifies :stop, "service[service_ca02a235-7432-46fe-847a-8f5f5258ce73_jar]", :immediately
		#notifies :disable, "service[service_ca02a235-7432-46fe-847a-8f5f5258ce73_jar]", :immediately
		action :delete
	end
end