#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ccad064b-98d2-46d4-b436-71c0846756a0_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/serviceccad064b-98d2-46d4-b436-71c0846756a0Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['ccad064b-98d2-46d4-b436-71c0846756a0']['installationDir']}/serviceccad064b-98d2-46d4-b436-71c0846756a0Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/serviceccad064b-98d2-46d4-b436-71c0846756a0Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ccad064b-98d2-46d4-b436-71c0846756a0']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ccad064b-98d2-46d4-b436-71c0846756a0']['InstallationDir']}/serviceccad064b-98d2-46d4-b436-71c0846756a0Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ccad064b-98d2-46d4-b436-71c0846756a0']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ccad064b-98d2-46d4-b436-71c0846756a0_jar]"
		notifies :start, "service[service_ccad064b-98d2-46d4-b436-71c0846756a0_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ccad064b-98d2-46d4-b436-71c0846756a0']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ccad064b-98d2-46d4-b436-71c0846756a0']['InstallationDir']}/serviceccad064b-98d2-46d4-b436-71c0846756a0Deploy.jar" do
		notifies :stop, "service[service_ccad064b-98d2-46d4-b436-71c0846756a0_jar]", :immediately
		#notifies :disable, "service[service_ccad064b-98d2-46d4-b436-71c0846756a0_jar]", :immediately
		action :delete
	end
end