#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_cde13392-4665-4d04-a6c2-2ddd8dec21df_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-cde13392-4665-4d04-a6c2-2ddd8dec21df.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-cde13392-4665-4d04-a6c2-2ddd8dec21df.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['cde13392-4665-4d04-a6c2-2ddd8dec21df']['InstallationDir']}/service-cde13392-4665-4d04-a6c2-2ddd8dec21df.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-cde13392-4665-4d04-a6c2-2ddd8dec21df.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['cde13392-4665-4d04-a6c2-2ddd8dec21df']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['cde13392-4665-4d04-a6c2-2ddd8dec21df']['InstallationDir']}/service-cde13392-4665-4d04-a6c2-2ddd8dec21df.jar" do
  		source "#{node['CHOReOSData']['serviceData']['cde13392-4665-4d04-a6c2-2ddd8dec21df']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_cde13392-4665-4d04-a6c2-2ddd8dec21df_jar]"
		notifies :start, "service[service_cde13392-4665-4d04-a6c2-2ddd8dec21df_jar]"
	end
end

if node['CHOReOSData']['serviceData']['cde13392-4665-4d04-a6c2-2ddd8dec21df']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['cde13392-4665-4d04-a6c2-2ddd8dec21df']['InstallationDir']}/service-cde13392-4665-4d04-a6c2-2ddd8dec21df.jar" do
		notifies :stop, "service[service_cde13392-4665-4d04-a6c2-2ddd8dec21df_jar]", :immediately
		#notifies :disable, "service[service_cde13392-4665-4d04-a6c2-2ddd8dec21df_jar]", :immediately
		action :delete
	end
end