#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e']['InstallationDir']}/service-ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e']['InstallationDir']}/service-ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e_jar]"
		notifies :start, "service[service_ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e']['InstallationDir']}/service-ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e.jar" do
		notifies :stop, "service[service_ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e_jar]", :immediately
		#notifies :disable, "service[service_ce0a2d9b-9aa8-46f0-9cfb-87e0c7dba39e_jar]", :immediately
		action :delete
	end
end