#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_d6646484-b005-467b-9ab5-89da97a2acdc_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-d6646484-b005-467b-9ab5-89da97a2acdc.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-d6646484-b005-467b-9ab5-89da97a2acdc.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['d6646484-b005-467b-9ab5-89da97a2acdc']['InstallationDir']}/service-d6646484-b005-467b-9ab5-89da97a2acdc.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-d6646484-b005-467b-9ab5-89da97a2acdc.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['d6646484-b005-467b-9ab5-89da97a2acdc']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['d6646484-b005-467b-9ab5-89da97a2acdc']['InstallationDir']}/service-d6646484-b005-467b-9ab5-89da97a2acdc.jar" do
  		source "#{node['CHOReOSData']['serviceData']['d6646484-b005-467b-9ab5-89da97a2acdc']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_d6646484-b005-467b-9ab5-89da97a2acdc_jar]"
		notifies :start, "service[service_d6646484-b005-467b-9ab5-89da97a2acdc_jar]"
	end
end

if node['CHOReOSData']['serviceData']['d6646484-b005-467b-9ab5-89da97a2acdc']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['d6646484-b005-467b-9ab5-89da97a2acdc']['InstallationDir']}/service-d6646484-b005-467b-9ab5-89da97a2acdc.jar" do
		notifies :stop, "service[service_d6646484-b005-467b-9ab5-89da97a2acdc_jar]", :immediately
		#notifies :disable, "service[service_d6646484-b005-467b-9ab5-89da97a2acdc_jar]", :immediately
		action :delete
	end
end