#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_da086f53-1d7b-4dec-be7a-b74230142e42_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/serviceda086f53-1d7b-4dec-be7a-b74230142e42Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['da086f53-1d7b-4dec-be7a-b74230142e42']['installationDir']}/serviceda086f53-1d7b-4dec-be7a-b74230142e42Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/serviceda086f53-1d7b-4dec-be7a-b74230142e42Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['da086f53-1d7b-4dec-be7a-b74230142e42']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['da086f53-1d7b-4dec-be7a-b74230142e42']['InstallationDir']}/serviceda086f53-1d7b-4dec-be7a-b74230142e42Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['da086f53-1d7b-4dec-be7a-b74230142e42']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_da086f53-1d7b-4dec-be7a-b74230142e42_jar]"
		notifies :start, "service[service_da086f53-1d7b-4dec-be7a-b74230142e42_jar]"
	end
end

if node['CHOReOSData']['serviceData']['da086f53-1d7b-4dec-be7a-b74230142e42']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['da086f53-1d7b-4dec-be7a-b74230142e42']['InstallationDir']}/serviceda086f53-1d7b-4dec-be7a-b74230142e42Deploy.jar" do
		notifies :stop, "service[service_da086f53-1d7b-4dec-be7a-b74230142e42_jar]", :immediately
		#notifies :disable, "service[service_da086f53-1d7b-4dec-be7a-b74230142e42_jar]", :immediately
		action :delete
	end
end