#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_e525ff1b-4f3f-4205-a233-3a67e3002daa_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/servicee525ff1b-4f3f-4205-a233-3a67e3002daaDeploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['e525ff1b-4f3f-4205-a233-3a67e3002daa']['installationDir']}/servicee525ff1b-4f3f-4205-a233-3a67e3002daaDeploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/servicee525ff1b-4f3f-4205-a233-3a67e3002daaDeploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['e525ff1b-4f3f-4205-a233-3a67e3002daa']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['e525ff1b-4f3f-4205-a233-3a67e3002daa']['InstallationDir']}/servicee525ff1b-4f3f-4205-a233-3a67e3002daaDeploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['e525ff1b-4f3f-4205-a233-3a67e3002daa']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_e525ff1b-4f3f-4205-a233-3a67e3002daa_jar]"
		notifies :start, "service[service_e525ff1b-4f3f-4205-a233-3a67e3002daa_jar]"
	end
end

if node['CHOReOSData']['serviceData']['e525ff1b-4f3f-4205-a233-3a67e3002daa']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['e525ff1b-4f3f-4205-a233-3a67e3002daa']['InstallationDir']}/servicee525ff1b-4f3f-4205-a233-3a67e3002daaDeploy.jar" do
		notifies :stop, "service[service_e525ff1b-4f3f-4205-a233-3a67e3002daa_jar]", :immediately
		#notifies :disable, "service[service_e525ff1b-4f3f-4205-a233-3a67e3002daa_jar]", :immediately
		action :delete
	end
end