#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_eb75d487-e239-4c18-9ba1-a79c3a79de9f_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/serviceeb75d487-e239-4c18-9ba1-a79c3a79de9fDeploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['eb75d487-e239-4c18-9ba1-a79c3a79de9f']['installationDir']}/serviceeb75d487-e239-4c18-9ba1-a79c3a79de9fDeploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/serviceeb75d487-e239-4c18-9ba1-a79c3a79de9fDeploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['eb75d487-e239-4c18-9ba1-a79c3a79de9f']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['eb75d487-e239-4c18-9ba1-a79c3a79de9f']['InstallationDir']}/serviceeb75d487-e239-4c18-9ba1-a79c3a79de9fDeploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['eb75d487-e239-4c18-9ba1-a79c3a79de9f']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_eb75d487-e239-4c18-9ba1-a79c3a79de9f_jar]"
		notifies :start, "service[service_eb75d487-e239-4c18-9ba1-a79c3a79de9f_jar]"
	end
end

if node['CHOReOSData']['serviceData']['eb75d487-e239-4c18-9ba1-a79c3a79de9f']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['eb75d487-e239-4c18-9ba1-a79c3a79de9f']['InstallationDir']}/serviceeb75d487-e239-4c18-9ba1-a79c3a79de9fDeploy.jar" do
		notifies :stop, "service[service_eb75d487-e239-4c18-9ba1-a79c3a79de9f_jar]", :immediately
		#notifies :disable, "service[service_eb75d487-e239-4c18-9ba1-a79c3a79de9f_jar]", :immediately
		action :delete
	end
end