#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_eea2b161-148a-4e36-b983-7a7d801ed628_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-eea2b161-148a-4e36-b983-7a7d801ed628.pid --exec /bin/bash -- -c \'echo $$ > /var/run/service-eea2b161-148a-4e36-b983-7a7d801ed628.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['eea2b161-148a-4e36-b983-7a7d801ed628']['installationDir']}/service-eea2b161-148a-4e36-b983-7a7d801ed628.jar\' "
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-eea2b161-148a-4e36-b983-7a7d801ed628.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['eea2b161-148a-4e36-b983-7a7d801ed628']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['eea2b161-148a-4e36-b983-7a7d801ed628']['InstallationDir']}/service-eea2b161-148a-4e36-b983-7a7d801ed628.jar" do
  		source "#{node['CHOReOSData']['serviceData']['eea2b161-148a-4e36-b983-7a7d801ed628']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_eea2b161-148a-4e36-b983-7a7d801ed628_jar]"
		notifies :start, "service[service_eea2b161-148a-4e36-b983-7a7d801ed628_jar]"
	end
end

if node['CHOReOSData']['serviceData']['eea2b161-148a-4e36-b983-7a7d801ed628']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['eea2b161-148a-4e36-b983-7a7d801ed628']['InstallationDir']}/service-eea2b161-148a-4e36-b983-7a7d801ed628.jar" do
		notifies :stop, "service[service_eea2b161-148a-4e36-b983-7a7d801ed628_jar]", :immediately
		#notifies :disable, "service[service_eea2b161-148a-4e36-b983-7a7d801ed628_jar]", :immediately
		action :delete
	end
end