#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ef602056-c6fd-46ce-97e1-e3eff066787b_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-ef602056-c6fd-46ce-97e1-e3eff066787b.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-ef602056-c6fd-46ce-97e1-e3eff066787b.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['ef602056-c6fd-46ce-97e1-e3eff066787b']['InstallationDir']}/service-ef602056-c6fd-46ce-97e1-e3eff066787b.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-ef602056-c6fd-46ce-97e1-e3eff066787b.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ef602056-c6fd-46ce-97e1-e3eff066787b']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ef602056-c6fd-46ce-97e1-e3eff066787b']['InstallationDir']}/service-ef602056-c6fd-46ce-97e1-e3eff066787b.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ef602056-c6fd-46ce-97e1-e3eff066787b']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ef602056-c6fd-46ce-97e1-e3eff066787b_jar]"
		notifies :start, "service[service_ef602056-c6fd-46ce-97e1-e3eff066787b_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ef602056-c6fd-46ce-97e1-e3eff066787b']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ef602056-c6fd-46ce-97e1-e3eff066787b']['InstallationDir']}/service-ef602056-c6fd-46ce-97e1-e3eff066787b.jar" do
		notifies :stop, "service[service_ef602056-c6fd-46ce-97e1-e3eff066787b_jar]", :immediately
		#notifies :disable, "service[service_ef602056-c6fd-46ce-97e1-e3eff066787b_jar]", :immediately
		action :delete
	end
end