#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_f6188087-1ccf-4be2-bfb6-9507b7a61f7e_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/servicef6188087-1ccf-4be2-bfb6-9507b7a61f7eDeploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['f6188087-1ccf-4be2-bfb6-9507b7a61f7e']['installationDir']}/servicef6188087-1ccf-4be2-bfb6-9507b7a61f7eDeploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/servicef6188087-1ccf-4be2-bfb6-9507b7a61f7eDeploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['f6188087-1ccf-4be2-bfb6-9507b7a61f7e']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['f6188087-1ccf-4be2-bfb6-9507b7a61f7e']['InstallationDir']}/servicef6188087-1ccf-4be2-bfb6-9507b7a61f7eDeploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['f6188087-1ccf-4be2-bfb6-9507b7a61f7e']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_f6188087-1ccf-4be2-bfb6-9507b7a61f7e_jar]"
		notifies :start, "service[service_f6188087-1ccf-4be2-bfb6-9507b7a61f7e_jar]"
	end
end

if node['CHOReOSData']['serviceData']['f6188087-1ccf-4be2-bfb6-9507b7a61f7e']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['f6188087-1ccf-4be2-bfb6-9507b7a61f7e']['InstallationDir']}/servicef6188087-1ccf-4be2-bfb6-9507b7a61f7eDeploy.jar" do
		notifies :stop, "service[service_f6188087-1ccf-4be2-bfb6-9507b7a61f7e_jar]", :immediately
		#notifies :disable, "service[service_f6188087-1ccf-4be2-bfb6-9507b7a61f7e_jar]", :immediately
		action :delete
	end
end