#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b']['InstallationDir']}/service-fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b']['InstallationDir']}/service-fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b.jar" do
  		source "#{node['CHOReOSData']['serviceData']['fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b_jar]"
		notifies :start, "service[service_fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b_jar]"
	end
end

if node['CHOReOSData']['serviceData']['fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b']['InstallationDir']}/service-fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b.jar" do
		notifies :stop, "service[service_fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b_jar]", :immediately
		#notifies :disable, "service[service_fccafa95-b47a-4d7b-a4a1-9d9d70b59e4b_jar]", :immediately
		action :delete
	end
end