#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_fd4cd79a-1cec-4cf1-8b5f-94498e3d8524_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-fd4cd79a-1cec-4cf1-8b5f-94498e3d8524.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-fd4cd79a-1cec-4cf1-8b5f-94498e3d8524.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['fd4cd79a-1cec-4cf1-8b5f-94498e3d8524']['InstallationDir']}/service-fd4cd79a-1cec-4cf1-8b5f-94498e3d8524.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-fd4cd79a-1cec-4cf1-8b5f-94498e3d8524.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['fd4cd79a-1cec-4cf1-8b5f-94498e3d8524']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['fd4cd79a-1cec-4cf1-8b5f-94498e3d8524']['InstallationDir']}/service-fd4cd79a-1cec-4cf1-8b5f-94498e3d8524.jar" do
  		source "#{node['CHOReOSData']['serviceData']['fd4cd79a-1cec-4cf1-8b5f-94498e3d8524']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_fd4cd79a-1cec-4cf1-8b5f-94498e3d8524_jar]"
		notifies :start, "service[service_fd4cd79a-1cec-4cf1-8b5f-94498e3d8524_jar]"
	end
end

if node['CHOReOSData']['serviceData']['fd4cd79a-1cec-4cf1-8b5f-94498e3d8524']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['fd4cd79a-1cec-4cf1-8b5f-94498e3d8524']['InstallationDir']}/service-fd4cd79a-1cec-4cf1-8b5f-94498e3d8524.jar" do
		notifies :stop, "service[service_fd4cd79a-1cec-4cf1-8b5f-94498e3d8524_jar]", :immediately
		#notifies :disable, "service[service_fd4cd79a-1cec-4cf1-8b5f-94498e3d8524_jar]", :immediately
		action :delete
	end
end