#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_fe403a4d-322b-47c8-b903-ef58de042a22_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/servicefe403a4d-322b-47c8-b903-ef58de042a22Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['fe403a4d-322b-47c8-b903-ef58de042a22']['installationDir']}/servicefe403a4d-322b-47c8-b903-ef58de042a22Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/servicefe403a4d-322b-47c8-b903-ef58de042a22Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['fe403a4d-322b-47c8-b903-ef58de042a22']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['fe403a4d-322b-47c8-b903-ef58de042a22']['InstallationDir']}/servicefe403a4d-322b-47c8-b903-ef58de042a22Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['fe403a4d-322b-47c8-b903-ef58de042a22']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_fe403a4d-322b-47c8-b903-ef58de042a22_jar]"
		notifies :start, "service[service_fe403a4d-322b-47c8-b903-ef58de042a22_jar]"
	end
end

if node['CHOReOSData']['serviceData']['fe403a4d-322b-47c8-b903-ef58de042a22']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['fe403a4d-322b-47c8-b903-ef58de042a22']['InstallationDir']}/servicefe403a4d-322b-47c8-b903-ef58de042a22Deploy.jar" do
		notifies :stop, "service[service_fe403a4d-322b-47c8-b903-ef58de042a22_jar]", :immediately
		#notifies :disable, "service[service_fe403a4d-322b-47c8-b903-ef58de042a22_jar]", :immediately
		action :delete
	end
end