#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_fe760878-df87-4787-870a-6acc2769a69a_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-fe760878-df87-4787-870a-6acc2769a69a.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-fe760878-df87-4787-870a-6acc2769a69a.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['fe760878-df87-4787-870a-6acc2769a69a']['InstallationDir']}/service-fe760878-df87-4787-870a-6acc2769a69a.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-fe760878-df87-4787-870a-6acc2769a69a.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['fe760878-df87-4787-870a-6acc2769a69a']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['fe760878-df87-4787-870a-6acc2769a69a']['InstallationDir']}/service-fe760878-df87-4787-870a-6acc2769a69a.jar" do
  		source "#{node['CHOReOSData']['serviceData']['fe760878-df87-4787-870a-6acc2769a69a']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_fe760878-df87-4787-870a-6acc2769a69a_jar]"
		notifies :start, "service[service_fe760878-df87-4787-870a-6acc2769a69a_jar]"
	end
end

if node['CHOReOSData']['serviceData']['fe760878-df87-4787-870a-6acc2769a69a']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['fe760878-df87-4787-870a-6acc2769a69a']['InstallationDir']}/service-fe760878-df87-4787-870a-6acc2769a69a.jar" do
		notifies :stop, "service[service_fe760878-df87-4787-870a-6acc2769a69a_jar]", :immediately
		#notifies :disable, "service[service_fe760878-df87-4787-870a-6acc2769a69a_jar]", :immediately
		action :delete
	end
end