#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_fece32b4-5e55-4860-8a5a-028fb982e801_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/servicefece32b4-5e55-4860-8a5a-028fb982e801Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['fece32b4-5e55-4860-8a5a-028fb982e801']['installationDir']}/servicefece32b4-5e55-4860-8a5a-028fb982e801Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/servicefece32b4-5e55-4860-8a5a-028fb982e801Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['fece32b4-5e55-4860-8a5a-028fb982e801']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['fece32b4-5e55-4860-8a5a-028fb982e801']['InstallationDir']}/servicefece32b4-5e55-4860-8a5a-028fb982e801Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['fece32b4-5e55-4860-8a5a-028fb982e801']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_fece32b4-5e55-4860-8a5a-028fb982e801_jar]"
		notifies :start, "service[service_fece32b4-5e55-4860-8a5a-028fb982e801_jar]"
	end
end

if node['CHOReOSData']['serviceData']['fece32b4-5e55-4860-8a5a-028fb982e801']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['fece32b4-5e55-4860-8a5a-028fb982e801']['InstallationDir']}/servicefece32b4-5e55-4860-8a5a-028fb982e801Deploy.jar" do
		notifies :stop, "service[service_fece32b4-5e55-4860-8a5a-028fb982e801_jar]", :immediately
		#notifies :disable, "service[service_fece32b4-5e55-4860-8a5a-028fb982e801_jar]", :immediately
		action :delete
	end
end