#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ff1475cf-0786-467f-b24f-71bc5aa16148_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/serviceff1475cf-0786-467f-b24f-71bc5aa16148Deploy.pid --exec `/usr/bin/which java` -- -jar #{node['CHOReOSData']['serviceData']['ff1475cf-0786-467f-b24f-71bc5aa16148']['installationDir']}/serviceff1475cf-0786-467f-b24f-71bc5aa16148Deploy.jar"
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/serviceff1475cf-0786-467f-b24f-71bc5aa16148Deploy.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ff1475cf-0786-467f-b24f-71bc5aa16148']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ff1475cf-0786-467f-b24f-71bc5aa16148']['InstallationDir']}/serviceff1475cf-0786-467f-b24f-71bc5aa16148Deploy.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ff1475cf-0786-467f-b24f-71bc5aa16148']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ff1475cf-0786-467f-b24f-71bc5aa16148_jar]"
		notifies :start, "service[service_ff1475cf-0786-467f-b24f-71bc5aa16148_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ff1475cf-0786-467f-b24f-71bc5aa16148']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ff1475cf-0786-467f-b24f-71bc5aa16148']['InstallationDir']}/serviceff1475cf-0786-467f-b24f-71bc5aa16148Deploy.jar" do
		notifies :stop, "service[service_ff1475cf-0786-467f-b24f-71bc5aa16148_jar]", :immediately
		#notifies :disable, "service[service_ff1475cf-0786-467f-b24f-71bc5aa16148_jar]", :immediately
		action :delete
	end
end