#
# Cookbook Name:: generic-jar-service-template
# Recipe:: default
#
# Copyright 2012, YOUR_COMPANY_NAME
#
# All rights reserved - Do Not Redistribute
#

##########################################################################
#                  #
#                IMPORTANT DEVELOPMENT NOTICE:                           #
#                  #
# All ocurrences of $ NAME must be replaced with the actual service name #
#            before uploading the recipe to the chef-server              #
#                  #
##########################################################################

include_recipe "apt" # java recipe is failing without recipe apt
include_recipe "java"


service "service_ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d_jar" do
 	start_command "start-stop-daemon -b --start --quiet --oknodo --pidfile /var/run/service-ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d.pid --exec /bin/bash -- -c \"echo $$ > /var/run/service-ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d.pid ; exec java -jar #{node['CHOReOSData']['serviceData']['ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d']['InstallationDir']}/service-ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d.jar\""
 	stop_command "start-stop-daemon --stop --signal 15 --quiet --oknodo --pidfile /var/run/service-ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d.pid"
 	action :nothing
 	supports :start => true, :stop => true
end

if node['CHOReOSData']['serviceData']['ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d']['NumberOfClients'] > 0
	remote_file "#{node['CHOReOSData']['serviceData']['ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d']['InstallationDir']}/service-ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d.jar" do
  		source "#{node['CHOReOSData']['serviceData']['ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d']['PackageURL']}"
  		action :create_if_missing
		#notifies :enable, "service[service_ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d_jar]"
		notifies :start, "service[service_ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d_jar]"
	end
end

if node['CHOReOSData']['serviceData']['ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d']['NumberOfClients'] <= 0
	file "#{node['CHOReOSData']['serviceData']['ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d']['InstallationDir']}/service-ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d.jar" do
		notifies :stop, "service[service_ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d_jar]", :immediately
		#notifies :disable, "service[service_ffb883f0-7b7a-48ba-b1d9-3997f1c5d97d_jar]", :immediately
		action :delete
	end
end