/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.services.datamodel;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.ow2.choreos.services.datamodel.DeployableServiceSpec;
import org.ow2.choreos.services.datamodel.Recipe;
import org.ow2.choreos.services.datamodel.Service;
import org.ow2.choreos.services.datamodel.ServiceInstance;
import org.ow2.choreos.services.datamodel.ServiceSpec;

@XmlRootElement
public class DeployableService
extends Service {
    private List<ServiceInstance> serviceInstances;
    @XmlTransient
    private Recipe recipe;

    public DeployableService() {
    }

    public DeployableService(DeployableServiceSpec spec) {
        super(spec);
    }

    @Override
    public DeployableServiceSpec getSpec() {
        return (DeployableServiceSpec)super.getSpec();
    }

    @Override
    public void setSpec(ServiceSpec spec) {
        super.setSpec((DeployableServiceSpec)spec);
    }

    public List<ServiceInstance> getInstances() {
        return this.serviceInstances;
    }

    public void setInstances(List<ServiceInstance> instances) {
        for (ServiceInstance ins : instances) {
            this.addInstance(ins);
        }
    }

    public void addInstance(ServiceInstance instance) {
        if (this.serviceInstances == null) {
            this.serviceInstances = new ArrayList<ServiceInstance>();
        }
        this.serviceInstances.add(instance);
        instance.setServiceSpec(this.getSpec());
    }

    @Override
    public List<String> getUris() {
        ArrayList<String> uris = new ArrayList<String>();
        for (ServiceInstance service : this.serviceInstances) {
            uris.add(service.getNativeUri());
        }
        return uris;
    }

    public ServiceInstance getInstance(String instanceId) {
        for (ServiceInstance instance : this.serviceInstances) {
            if (!instance.getInstanceId().equals(instanceId)) continue;
            return instance;
        }
        throw new IllegalArgumentException("getSpec().getUUID()  / " + instanceId);
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public void setRecipe(Recipe recipe) {
        this.recipe = recipe;
    }
}

