/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.chef.impl;

import java.io.File;
import java.util.List;
import org.ow2.choreos.chef.Knife;
import org.ow2.choreos.chef.KnifeClient;
import org.ow2.choreos.chef.KnifeCookbook;
import org.ow2.choreos.chef.KnifeException;
import org.ow2.choreos.chef.KnifeNode;
import org.ow2.choreos.chef.impl.ChefScripts;
import org.ow2.choreos.chef.impl.KnifeClientImpl;
import org.ow2.choreos.chef.impl.KnifeCookbookImpl;
import org.ow2.choreos.chef.impl.KnifeNodeImpl;
import org.ow2.choreos.utils.CommandLine;
import org.ow2.choreos.utils.CommandLineException;

public class KnifeImpl
implements Knife {
    private static final String EXIT_STATUS_ERROR_MESSAGE = "Knife exit status > 0";
    private ChefScripts scripts;
    private KnifeNode knifeNode;
    private KnifeCookbook knifeCookbook;
    private KnifeClient knifeClient;
    private String chefRepo;
    private boolean verbose;

    public KnifeImpl(String knifeConfigFile, String chefRepo, boolean verbose) {
        File knifeConfig = new File(knifeConfigFile);
        if (!knifeConfig.exists()) {
            throw new IllegalArgumentException(knifeConfigFile + " does not exist!");
        }
        this.scripts = new ChefScripts(knifeConfigFile);
        this.knifeNode = new KnifeNodeImpl(knifeConfigFile, verbose);
        this.knifeCookbook = new KnifeCookbookImpl(knifeConfigFile, chefRepo, verbose);
        this.knifeClient = new KnifeClientImpl(knifeConfigFile, verbose);
        this.chefRepo = chefRepo;
        this.verbose = verbose;
    }

    public KnifeImpl(String knifeConfigFile, String chefRepo) {
        this(knifeConfigFile, chefRepo, false);
    }

    @Override
    public KnifeNode node() {
        return this.knifeNode;
    }

    @Override
    public KnifeCookbook cookbook() {
        return this.knifeCookbook;
    }

    @Override
    public KnifeClient client() {
        return this.knifeClient;
    }

    @Override
    public String bootstrap(String ip, String user, String pKeyFile, List<String> defaultRecipes) throws KnifeException {
        String command = this.scripts.getKnifeBootstrap(pKeyFile, ip, user, defaultRecipes);
        try {
            return CommandLine.run(command, this.chefRepo, this.verbose);
        }
        catch (CommandLineException e) {
            throw new KnifeException(EXIT_STATUS_ERROR_MESSAGE, command);
        }
    }
}

