/*
 * Decompiled with CFR 0.152.
 */
package eu.playproject.governance.service;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.WsrfbfModelFactoryImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.impl.impl.WsrfrModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl.WsrfrlModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl.WsrfrpModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import eu.playproject.governance.api.EventGovernance;
import eu.playproject.governance.api.GovernanceExeption;
import eu.playproject.governance.api.bean.Topic;
import eu.playproject.governance.service.GovernanceEngine;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import javax.xml.namespace.QName;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.petalslink.dsb.notification.client.http.simple.HTTPProducerRPClient;
import org.petalslink.dsb.notification.commons.NotificationException;

public class EventGovernanceService
implements EventGovernance {
    static Logger logger = Logger.getLogger(EventGovernanceService.class.getName());

    static {
        logger.info("Creating WSN factories...");
        Wsnb4ServUtils.initModelFactories((WsrfbfModelFactory)new WsrfbfModelFactoryImpl(), (WsrfrModelFactory)new WsrfrModelFactoryImpl(), (WsrfrlModelFactory)new WsrfrlModelFactoryImpl(), (WsrfrpModelFactory)new WsrfrpModelFactoryImpl(), (WstopModelFactory)new WstopModelFactoryImpl(), (WsnbModelFactory)new WsnbModelFactoryImpl());
    }

    @WebMethod(exclude=true)
    public void loadResources(InputStream topicNameSpaceInputStream) throws GovernanceExeption {
        throw new GovernanceExeption("Not implemented");
    }

    public void createTopic(Topic topic) throws GovernanceExeption {
        GovernanceEngine.getInstance().createTopic(topic);
    }

    public List<Topic> getTopics() {
        logger.fine("Get topics...");
        ArrayList<Topic> result = new ArrayList<Topic>();
        Properties props = null;
        try {
            props = new Properties();
            URL url = new URL("https://raw.github.com/play-project/play-configfiles/master/platformservices/platform.properties");
            props.load(url.openStream());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return result;
        }
        String endpoint = props.getProperty("endpoint.topic");
        HTTPProducerRPClient client = new HTTPProducerRPClient(endpoint);
        try {
            List topics = client.getTopics();
            if (topics != null) {
                for (QName qName : topics) {
                    logger.info("Topic : " + qName);
                    Topic topic = new Topic();
                    topic.setName(qName.getLocalPart());
                    topic.setNs(qName.getNamespaceURI());
                    topic.setPrefix(qName.getPrefix());
                    result.add(topic);
                }
            }
        }
        catch (NotificationException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<QName> findTopicsByElement(QName element) throws GovernanceExeption {
        throw new GovernanceExeption("Not implemented");
    }

    public List<W3CEndpointReference> findEventProducersByTopics(List<QName> topics) throws GovernanceExeption {
        throw new GovernanceExeption("Not implemented");
    }

    public List<W3CEndpointReference> findEventProducersByElements(List<QName> element) throws GovernanceExeption {
        throw new GovernanceExeption("Not implemented");
    }
}

