/*
 * Decompiled with CFR 0.152.
 */
package eu.playproject.governance.service;

import eu.playproject.governance.api.GovernanceExeption;
import eu.playproject.governance.api.bean.Metadata;
import eu.playproject.governance.api.bean.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class GovernanceEngine {
    static Logger logger = Logger.getLogger(GovernanceEngine.class.getName());
    Map<Topic, Set<Metadata>> metadata = new ConcurrentHashMap<Topic, Set<Metadata>>();
    private static GovernanceEngine instance;

    public static synchronized GovernanceEngine getInstance() {
        if (instance == null) {
            instance = new GovernanceEngine();
        }
        return instance;
    }

    private GovernanceEngine() {
    }

    public synchronized void addMetadata(Topic topic, Metadata metadata) {
        if (!this.topicExists(topic)) {
            this.createTopic(topic);
        }
        this.metadata.get(topic).add(metadata);
    }

    public synchronized void removeMetadata(Topic topic, Metadata metadata) {
        if (!this.topicExists(topic)) {
            return;
        }
        this.metadata.get(topic).remove(metadata);
    }

    public List<Metadata> getMetaData(Topic topic) throws GovernanceExeption {
        ArrayList<Metadata> result = new ArrayList<Metadata>();
        Set<Metadata> set = this.metadata.get(topic);
        if (set != null) {
            result.addAll((Collection<Metadata>)this.metadata.get(topic));
        }
        return result;
    }

    public Metadata getMetaData(Topic topic, String key) throws GovernanceExeption {
        Set<Metadata> set;
        List<Metadata> result = this.getMetaData(topic);
        Metadata m = null;
        if (result != null) {
            // empty if block
        }
        if ((set = this.metadata.get(topic)) != null) {
            Iterator<Metadata> iter = set.iterator();
            boolean found = false;
            while (!found && iter.hasNext()) {
                Metadata tmp = iter.next();
                if (!key.equals(tmp.getName())) continue;
                found = true;
                m = tmp;
            }
        }
        return m;
    }

    public boolean topicExists(Topic topic) {
        return this.metadata.containsKey(topic);
    }

    public synchronized void createTopic(Topic topic) {
        if (!this.topicExists(topic)) {
            this.metadata.put(topic, new HashSet());
        }
    }

    public List<Topic> getTopics() {
        ArrayList<Topic> result = new ArrayList<Topic>();
        result.addAll(this.metadata.keySet());
        return result;
    }

    public void deleteMetadata(Topic topic) {
        if (this.topicExists(topic)) {
            this.metadata.get(topic).clear();
        }
    }
}

