/*
 * Decompiled with CFR 0.152.
 */
package eu.playproject.governance.service;

import eu.playproject.governance.api.EventGovernance;
import eu.playproject.governance.api.GovernanceExeption;
import eu.playproject.governance.api.GovernanceManagement;
import eu.playproject.governance.api.TopicMetadataLoader;
import eu.playproject.governance.api.TopicMetadataService;
import eu.playproject.governance.api.bean.Metadata;
import eu.playproject.governance.api.bean.Topic;
import eu.playproject.governance.api.bean.TopicMetadata;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class GovernanceManagementService
implements GovernanceManagement {
    static Logger logger = Logger.getLogger(GovernanceManagementService.class.getName());
    private String config = "https://raw.github.com/play-project/play-configfiles/master/platformservices/governancemetadata/metadata.json";
    boolean started = false;
    private TopicMetadataLoader loader;
    private TopicMetadataService topicMetadataService;
    private EventGovernance eventGovernance;

    public void start() throws GovernanceExeption {
        URL url;
        if (this.started) {
            throw new GovernanceExeption("Already started, please stop before...");
        }
        logger.fine("Starting...");
        try {
            url = new URL(this.config);
        }
        catch (MalformedURLException e) {
            logger.warning("Can not build the URL");
            throw new GovernanceExeption("Can not build the URL from " + this.config);
        }
        Collection list = this.loader.load(url);
        logger.fine("Number of meta entries " + list.size());
        for (TopicMetadata topicMetadata : list) {
            logger.info("Processing Metadata for topic " + topicMetadata.getTopic());
            Topic topic = this.getTopicFromName(topicMetadata.getTopic());
            if (topic != null) {
                for (Metadata meta : topicMetadata.getMetadata()) {
                    logger.info("Metadata : " + meta.getName() + ":" + meta.getValue());
                    this.topicMetadataService.addMetadata(topic, meta);
                }
                continue;
            }
            logger.info("Can not find the topic " + topicMetadata.getTopic());
        }
        this.started = true;
    }

    public void stop() throws GovernanceExeption {
        if (!this.started) {
            throw new GovernanceExeption("Already stopped");
        }
        this.started = false;
    }

    protected Topic getTopicFromName(String name) {
        logger.fine("Getting topic " + name);
        List topics = this.eventGovernance.getTopics();
        boolean found = false;
        Topic topic = null;
        Iterator it = topics.iterator();
        while (it.hasNext() && !found) {
            topic = (Topic)it.next();
            found = topic != null && name.equals(topic.getName());
        }
        logger.fine("Topic found : " + topic);
        return topic;
    }

    public void setLoader(TopicMetadataLoader loader) {
        this.loader = loader;
    }

    public void setTopicMetadataService(TopicMetadataService topicMetadataService) {
        this.topicMetadataService = topicMetadataService;
    }

    public void setEventGovernance(EventGovernance eventGovernance) {
        this.eventGovernance = eventGovernance;
    }
}

