/*
 * Decompiled with CFR 0.152.
 */
package eu.playproject.governance.service;

import eu.playproject.governance.api.bean.Metadata;
import eu.playproject.governance.api.bean.Topic;
import eu.playproject.governance.service.GovernanceEngine;
import eu.playproject.governance.service.TopicMetadataService;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TopicMetaDataServiceTest
extends TestCase {
    public void testFilterInclude() throws Exception {
        GovernanceEngine gov = GovernanceEngine.getInstance();
        Topic t = new Topic();
        t.setName("t1");
        t.setNs("http://foo/bar");
        t.setPrefix("ns");
        gov.createTopic(t);
        Topic t2 = new Topic();
        t2.setName("t2");
        t2.setNs("http://foo/bar");
        t2.setPrefix("ns");
        gov.createTopic(t2);
        Metadata meta = new Metadata();
        meta.setName("foo");
        meta.setName("bar");
        Metadata meta2 = new Metadata();
        meta2.setName("hello");
        meta2.setName("world");
        gov.addMetadata(t, meta);
        gov.addMetadata(t2, meta2);
        TopicMetadataService service = new TopicMetadataService();
        ArrayList<Metadata> filter = new ArrayList<Metadata>();
        filter.add(meta);
        List filtered = service.getTopicsWithMeta(filter);
        TopicMetaDataServiceTest.assertEquals((int)1, (int)filtered.size());
        TopicMetaDataServiceTest.assertEquals((String)"t1", (String)((Topic)filtered.get(0)).getName());
    }

    public void testNoFilter() throws Exception {
        TopicMetadataService service = new TopicMetadataService();
        ArrayList filter = new ArrayList();
        List filtered = service.getTopicsWithMeta(filter);
        TopicMetaDataServiceTest.assertEquals((int)0, (int)filtered.size());
    }

    public void testNullFilter() throws Exception {
        TopicMetadataService service = new TopicMetadataService();
        List filtered = service.getTopicsWithMeta(null);
        TopicMetaDataServiceTest.assertEquals((int)0, (int)filtered.size());
    }
}

