/*
 * Decompiled with CFR 0.152.
 */
package eu.playproject.governance.service;

import eu.playproject.governance.api.GovernanceExeption;
import eu.playproject.governance.api.bean.Metadata;
import eu.playproject.governance.api.bean.Topic;
import eu.playproject.governance.service.GovernanceEngine;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TopicMetadataService
implements eu.playproject.governance.api.TopicMetadataService {
    public void addMetadata(Topic topic, Metadata metadata) throws GovernanceExeption {
        if (topic == null || metadata == null) {
            throw new GovernanceExeption("Topic/metadata can not be null");
        }
        GovernanceEngine.getInstance().addMetadata(topic, metadata);
    }

    public void removeMetadata(Topic topic, Metadata metadata) throws GovernanceExeption {
        if (topic == null || metadata == null) {
            throw new GovernanceExeption("Topic/metadata can not be null");
        }
        GovernanceEngine.getInstance().removeMetadata(topic, metadata);
    }

    public List<Metadata> getMetaData(Topic topic) throws GovernanceExeption {
        if (topic == null) {
            throw new GovernanceExeption("Topic can not be null");
        }
        return GovernanceEngine.getInstance().getMetaData(topic);
    }

    public Metadata getMetadata(Topic topic, String key) throws GovernanceExeption {
        if (topic == null || key == null) {
            throw new GovernanceExeption("Topic/key can not be null");
        }
        return GovernanceEngine.getInstance().getMetaData(topic, key);
    }

    public boolean deleteMetaData(Topic topic) throws GovernanceExeption {
        if (topic == null) {
            throw new GovernanceExeption("Topic can not be null");
        }
        GovernanceEngine.getInstance().deleteMetadata(topic);
        return true;
    }

    public List<Topic> getTopicsWithMeta(List<Metadata> include) throws GovernanceExeption {
        ArrayList<Topic> result = new ArrayList<Topic>();
        if (include == null) {
            return result;
        }
        List<Topic> topics = GovernanceEngine.getInstance().getTopics();
        HashSet<Topic> included = new HashSet<Topic>();
        if (include != null) {
            for (Topic topic : topics) {
                List<Metadata> topicMetadata = this.getMetaData(topic);
                if (topicMetadata == null) continue;
                for (Metadata meta : include) {
                    if (!topicMetadata.contains(meta)) continue;
                    included.add(topic);
                }
            }
        }
        result.addAll(included);
        return result;
    }
}

