/*
 * Decompiled with CFR 0.152.
 */
package eu.playproject.platform.service.bootstrap;

import eu.playproject.commons.utils.StreamHelper;
import eu.playproject.governance.api.bean.Topic;
import eu.playproject.platform.service.bootstrap.MemoryLogServiceImpl;
import eu.playproject.platform.service.bootstrap.api.BootstrapFault;
import eu.playproject.platform.service.bootstrap.api.BootstrapService;
import eu.playproject.platform.service.bootstrap.api.EventCloudClientFactory;
import eu.playproject.platform.service.bootstrap.api.GovernanceClient;
import eu.playproject.platform.service.bootstrap.api.LogService;
import eu.playproject.platform.service.bootstrap.api.Subscription;
import eu.playproject.platform.service.bootstrap.api.SubscriptionRegistry;
import eu.playproject.platform.service.bootstrap.api.TopicManager;
import fr.inria.eventcloud.webservices.api.EventCloudManagementWsApi;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.ow2.play.metadata.api.Data;
import org.ow2.play.metadata.api.Metadata;
import org.ow2.play.metadata.api.MetadataException;
import org.ow2.play.metadata.api.Resource;
import org.ow2.play.metadata.api.service.MetadataService;

public class DSBSubscribesToECBootstrapServiceImpl
implements BootstrapService {
    private static Logger logger = Logger.getLogger(DSBSubscribesToECBootstrapServiceImpl.class.getName());
    private TopicManager topicManager;
    private EventCloudClientFactory eventCloudClientFactory;
    private GovernanceClient governanceClient;
    private SubscriptionRegistry subscriptionRegistry;
    private MetadataService metadataServiceClient;

    public List<Subscription> bootstrap(String eventCloudEndpoint, String subscriberEndpoint) throws BootstrapFault {
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        if (eventCloudEndpoint == null) {
            throw new BootstrapFault("Can not find any EventCloud endpoint, please check the settings");
        }
        if (subscriberEndpoint == null) {
            throw new BootstrapFault("Can not find any subscriber endpoint, please check the settings");
        }
        List topics = this.governanceClient.getTopics();
        if (topics == null || topics.size() == 0) {
            throw new BootstrapFault("Can not get any topic from the governance");
        }
        for (Topic topic : topics) {
            try {
                Subscription subscription = this.createResources(topic, eventCloudEndpoint, subscriberEndpoint);
                if (subscription == null) continue;
                result.add(subscription);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    protected Subscription createResources(Topic topic, String eventCloudEndpoint, String subscriberEndpoint) throws BootstrapFault {
        Subscription result = null;
        LogService log = MemoryLogServiceImpl.get();
        QName topicName = new QName(topic.getNs(), topic.getName(), topic.getPrefix());
        logger.info("Let's do it for topic " + topic);
        EventCloudManagementWsApi client = this.eventCloudClientFactory.getClient(eventCloudEndpoint);
        String streamName = StreamHelper.getStreamName((QName)topicName);
        boolean created = client.createEventCloud(streamName);
        if (created) {
            String subscribeEndpoint = client.createSubscribeProxy(streamName);
            client.createPublishProxy(streamName);
            client.createPutGetProxy(streamName);
            log.log("EventCloud has been created for stream %s", new Object[]{streamName});
        } else {
            log.log("EventCloud has been already created for stream %s", new Object[]{streamName});
        }
        if (this.needsToSubscribe(streamName)) {
            if (this.alreadySubscribed(topic, eventCloudEndpoint, subscriberEndpoint)) {
                log.log("DSB already subscribed to EC for topic %s", new Object[]{topic});
                logger.info(String.format("Already subscribed to topic %s", topic));
                return result;
            }
            List endpoints = client.getSubscribeProxyEndpointUrls(streamName);
            if (endpoints == null || endpoints.size() == 0) {
                log.log("Can not find any subscribe endpoint in the EC for stream %s", new Object[]{streamName});
            } else {
                log.log("Let's subscribe to eventcloud for stream %s", new Object[]{streamName});
                result = this.topicManager.subscribe((String)endpoints.get(0), topicName, subscriberEndpoint);
                log.log("DSB subscribed to EC : " + result);
            }
        } else {
            log.log("Do not need to subscribe to eventcloud for stream %s", new Object[]{streamName});
        }
        return result;
    }

    protected boolean alreadySubscribed(Topic topic, String eventCloudEndpoint, String subscriberEndpoint) {
        List subscriptions = this.subscriptionRegistry.getSubscriptions();
        Iterator iter = subscriptions.iterator();
        boolean found = false;
        while (iter.hasNext() && !found) {
            Subscription subscription = (Subscription)iter.next();
            found = subscription.getTopic().equals((Object)topic) && subscription.getSubscriber().equals(subscriberEndpoint);
        }
        return found;
    }

    protected boolean needsToSubscribe(String stream) {
        if (stream == null) {
            return false;
        }
        Resource r = new Resource("stream", stream);
        Metadata metadata = null;
        try {
            metadata = this.metadataServiceClient.getMetadataValue(r, "http://www.play-project.eu/xml/ns/dsbneedstosubscribe");
        }
        catch (MetadataException e) {
            return false;
        }
        return metadata != null && metadata.getData().contains(new Data("literal", "true"));
    }

    public void setTopicManager(TopicManager topicManager) {
        this.topicManager = topicManager;
    }

    public void setEventCloudClientFactory(EventCloudClientFactory eventCloudClientFactory) {
        this.eventCloudClientFactory = eventCloudClientFactory;
    }

    public void setGovernanceClient(GovernanceClient governanceClient) {
        this.governanceClient = governanceClient;
    }

    public void setSubscriptionRegistry(SubscriptionRegistry subscriptionRegistry) {
        this.subscriptionRegistry = subscriptionRegistry;
    }

    public void setMetadataServiceClient(MetadataService metadataServiceClient) {
        this.metadataServiceClient = metadataServiceClient;
    }
}

