/*
 * Decompiled with CFR 0.152.
 */
package eu.playproject.platform.service.bootstrap;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import org.ow2.play.service.registry.api.Registry;

public class InMemoryLocalRegistryServiceImpl
implements Registry {
    private static Logger logger = Logger.getLogger(InMemoryLocalRegistryServiceImpl.class.getName());
    private Map<String, String> map = new HashMap();
    private List<String> list = new ArrayList();
    private boolean loaded = false;

    protected synchronized void loadAll() {
        logger.info("Loading data");
        for (String url : this.list) {
            this.load(url);
        }
        this.loaded = true;
    }

    @WebMethod
    public void clear() {
        this.map = new HashMap();
        this.loaded = false;
    }

    @WebMethod
    public String get(String key) {
        if (!this.loaded) {
            this.loadAll();
        }
        return (String)this.map.get(key);
    }

    @WebMethod
    public List<String> keys() {
        if (!this.loaded) {
            this.loadAll();
        }
        return new ArrayList<String>(this.map.keySet());
    }

    @WebMethod
    public void load(String url) {
        block4: {
            if (url == null) {
                return;
            }
            Properties props = new Properties();
            try {
                URL u = new URL(url);
                props.load(u.openStream());
                for (String key : props.stringPropertyNames()) {
                    this.map.put(key, props.getProperty(key));
                }
            }
            catch (Exception e) {
                logger.warning(e.getMessage());
                if (!logger.isLoggable(Level.FINE)) break block4;
                e.printStackTrace();
            }
        }
    }

    @WebMethod
    public void put(String key, String value) {
        this.map.put(key, value);
    }

    public void setList(List<String> list) {
        logger.info("Set list " + list);
        this.list = list;
    }
}

