/*
 * Decompiled with CFR 0.152.
 */
package eu.playproject.platform.service.bootstrap;

import eu.playproject.platform.service.bootstrap.api.Subscription;
import eu.playproject.platform.service.bootstrap.api.SubscriptionRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class SubscriptionRegistryServiceImpl
implements SubscriptionRegistry {
    private static Logger logger = Logger.getLogger(SubscriptionRegistryServiceImpl.class.getName());
    List<Subscription> subscriptions = new ArrayList();

    public void addSubscription(Subscription subscription) {
        if (subscription != null) {
            this.subscriptions.add(subscription);
        }
    }

    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public List<Subscription> removeAll() {
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        for (Subscription s : this.subscriptions) {
            if (!this.subscriptions.remove(s)) continue;
            result.add(s);
        }
        return result;
    }

    public boolean remove(Subscription subscription) {
        logger.info("Remove from " + subscription);
        return this.subscriptions.remove(subscription);
    }

    public List<Subscription> removeAllFromConsumer(String consumer) {
        logger.info("Remove from consumer " + consumer);
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        Iterator iter = this.subscriptions.iterator();
        while (iter.hasNext()) {
            Subscription subscription = (Subscription)iter.next();
            if (subscription.getSubscriber() == null || !subscription.getSubscriber().equals(consumer)) continue;
            iter.remove();
            result.add(subscription);
        }
        return result;
    }

    public List<Subscription> removeAllFromProvider(String provider) {
        logger.info("Remove from provider " + provider);
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        Iterator iter = this.subscriptions.iterator();
        while (iter.hasNext()) {
            Subscription subscription = (Subscription)iter.next();
            if (subscription.getSubscriber() == null || !subscription.getProvider().equals(provider)) continue;
            iter.remove();
            result.add(subscription);
        }
        return result;
    }
}

