/*
 * Decompiled with CFR 0.152.
 */
package eu.playproject.platform.service.bootstrap.rest;

import eu.playproject.platform.service.bootstrap.MemoryLogServiceImpl;
import eu.playproject.platform.service.bootstrap.api.BootstrapFault;
import eu.playproject.platform.service.bootstrap.api.BootstrapService;
import eu.playproject.platform.service.bootstrap.api.Subscription;
import eu.playproject.platform.service.bootstrap.api.rest.InitService;
import eu.playproject.platform.service.bootstrap.api.rest.beans.Subscriptions;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.ow2.play.service.registry.api.Registry;

public class InitServiceImpl
implements InitService {
    protected static Logger logger = Logger.getLogger(InitServiceImpl.class.getName());
    private BootstrapService dsbSubscribesBootstrapService;
    private BootstrapService ecSubscribesBootstrapService;
    private Registry endpointRegistry;
    private static String DSBSUBSCRIBE2EC_ECENDPOINT = "endpoint.dsb2ec.eventcloud";
    private static String DSBSUBSCRIBE2EC_DSBENDPOINT = "endpoint.dsb2ec.subscriber";
    private static String ECSUBSCRIBES2DSB_DSBENDPOINT = "endpoint.ec2dsb.dsb";
    private static String ECSUBSCRIBES2DSB_ECBENDPOINT = "endpoint.ec2dsb.eventcloud";

    public Response go() {
        MemoryLogServiceImpl.get().log("Call to bootstrap service");
        ArrayList result = new ArrayList();
        result.addAll(this.dsbSubscribes2EC());
        result.addAll(this.ecSubscribes2DSB());
        return Response.ok((Object)new Subscriptions(result)).build();
    }

    public Response ecToDSB() {
        return Response.ok((Object)new Subscriptions(this.ecSubscribes2DSB())).build();
    }

    public Response dsbToEC() {
        return Response.ok((Object)new Subscriptions(this.dsbSubscribes2EC())).build();
    }

    protected List<Subscription> dsbSubscribes2EC() {
        MemoryLogServiceImpl.get().log("DSB subscribes to EC");
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        String eventCloudEndpoint = this.endpointRegistry.get(DSBSUBSCRIBE2EC_ECENDPOINT);
        String subscriberEndpoint = this.endpointRegistry.get(DSBSUBSCRIBE2EC_DSBENDPOINT);
        logger.info(String.format("Initializing with ec %s and subscriber %s", eventCloudEndpoint, subscriberEndpoint));
        try {
            result.addAll(this.dsbSubscribesBootstrapService.bootstrap(eventCloudEndpoint, subscriberEndpoint));
            if (logger.isLoggable(Level.FINE)) {
                for (Subscription s : result) {
                    logger.fine("Subscribed : " + s);
                }
            }
        }
        catch (BootstrapFault e) {
            e.printStackTrace();
        }
        return result;
    }

    protected List<Subscription> ecSubscribes2DSB() {
        MemoryLogServiceImpl.get().log("EC subscribes to DSB");
        ArrayList<Subscription> result = new ArrayList<Subscription>();
        String eventCloudEndpoint = this.endpointRegistry.get(ECSUBSCRIBES2DSB_ECBENDPOINT);
        String dsbEndpoint = this.endpointRegistry.get(ECSUBSCRIBES2DSB_DSBENDPOINT);
        logger.info(String.format("Initializing with ec %s and dsb %s", eventCloudEndpoint, dsbEndpoint));
        try {
            result.addAll(this.ecSubscribesBootstrapService.bootstrap(dsbEndpoint, eventCloudEndpoint));
            if (logger.isLoggable(Level.FINE)) {
                for (Subscription s : result) {
                    logger.fine("Subscribed : " + s);
                }
            }
        }
        catch (BootstrapFault e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setDsbSubscribesBootstrapService(BootstrapService dsbSubscribesBootstrapService) {
        this.dsbSubscribesBootstrapService = dsbSubscribesBootstrapService;
    }

    public void setEcSubscribesBootstrapService(BootstrapService ecSubscribesBootstrapService) {
        this.ecSubscribesBootstrapService = ecSubscribesBootstrapService;
    }

    public void setEndpointRegistry(Registry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }
}

