/*
 * Decompiled with CFR 0.152.
 */
package eu.play_project.play_platformservices;

import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.serializer.PlaySerializer;
import eu.play_project.dcep.api.DcepManagmentApi;
import eu.play_project.play_commons.constants.Constants;
import eu.play_project.play_platformservices.api.EpSparqlQuery;
import eu.play_project.play_platformservices.api.QueryDetails;
import eu.play_project.play_platformservices.api.QueryDispatchApi;
import eu.play_project.play_platformservices.jaxb.Query;
import eu.play_project.play_platformservices_querydispatcher.api.EleGenerator;
import eu.play_project.play_platformservices_querydispatcher.epsparql.visitor.realtime.EleGeneratorForConstructQuery;
import eu.play_project.play_platformservices_querydispatcher.epsparql.visitor.realtime.StreamIdCollector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.proactive.Body;
import org.objectweb.proactive.RunActive;
import org.objectweb.proactive.Service;
import org.objectweb.proactive.core.component.body.ComponentEndActive;
import org.objectweb.proactive.core.component.body.ComponentInitActive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(serviceName="QueryDispatchApi", portName="QueryDispatchApiPort", endpointInterface="eu.play_project.play_platformservices.api.QueryDispatchApi")
public class PlayPlatformservices
implements QueryDispatchApi,
ComponentInitActive,
ComponentEndActive,
BindingController,
RunActive,
Serializable {
    private static final long serialVersionUID = 1L;
    private EleGenerator eleGenerator;
    private DcepManagmentApi dcepManagmentApi;
    private boolean init = false;
    private Logger logger;
    private Endpoint soapEndpoint;
    private Service service;

    public String[] listFc() {
        return new String[]{"DcepManagmentApi"};
    }

    public Object lookupFc(String clientItfName) throws NoSuchInterfaceException {
        if ("DcepManagmentApi".equals(clientItfName)) {
            return this.dcepManagmentApi;
        }
        throw new NoSuchInterfaceException("DcepManagmentApi");
    }

    public void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (clientItfName.equals("DcepManagmentApi")) {
            this.dcepManagmentApi = (DcepManagmentApi)serverItf;
        }
    }

    public void unbindFc(String clientItfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
    }

    public void initComponentActivity(Body body) {
        if (!this.init) {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.logger.info("Initialising {} component.", (Object)this.getClass().getSimpleName());
            this.eleGenerator = new EleGeneratorForConstructQuery();
            try {
                this.soapEndpoint = Endpoint.publish((String)Constants.getProperties().getProperty("platfomservices.querydispatchapi.endpoint"), (Object)this);
            }
            catch (Exception e) {
                this.logger.error("Exception while publishing QueryDispatch Web Service endpoint", (Throwable)e);
            }
            this.init = true;
        }
    }

    public void endComponentActivity(Body arg0) {
        this.logger.info("Terminating {} component.", (Object)this.getClass().getSimpleName());
        if (this.soapEndpoint != null) {
            this.soapEndpoint.stop();
        }
        this.init = false;
    }

    public void runActivity(Body body) {
        this.service = new Service(body);
        while (body.isActive()) {
            this.service.waitForRequest();
            this.service.serveOldest();
        }
    }

    public synchronized String registerQuery(String queryId, String query) {
        if (!this.init) {
            throw new IllegalStateException("Component not initialized: " + this.getClass().getSimpleName());
        }
        com.hp.hpl.jena.query.Query q = QueryFactory.create((String)query, (Syntax)Syntax.syntaxEPSPARQL_20);
        this.eleGenerator.setPatternId("'" + queryId + "'");
        this.eleGenerator.generateAll(q);
        this.logger.info("Registering query " + q);
        QueryDetails qd = this.createQueryDetails(queryId, q);
        EpSparqlQuery epQuery = new EpSparqlQuery(qd, this.eleGenerator.getEle());
        epQuery.sethistoricalQueries(PlaySerializer.serializeToMultipleSelectQueries((com.hp.hpl.jena.query.Query)q));
        epQuery.setConstructTemplate(this.eleGenerator.getQueryTemplate());
        try {
            this.dcepManagmentApi.registerEventPattern(epQuery);
        }
        catch (Exception e) {
            this.logger.error("Error while registering query: " + queryId, (Throwable)e);
        }
        return queryId;
    }

    public void unregisterQuery(String queryId) {
        if (!this.init) {
            throw new IllegalStateException("Component not initialized: " + this.getClass().getSimpleName());
        }
        this.logger.info("Unregistering query " + queryId);
        this.dcepManagmentApi.unregisterEventPattern(queryId);
    }

    public QueryDetails analyseQuery(String queryId, String query) {
        if (!this.init) {
            throw new IllegalStateException("Component not initialized: " + this.getClass().getSimpleName());
        }
        com.hp.hpl.jena.query.Query q = QueryFactory.create((String)query, (Syntax)Syntax.syntaxEPSPARQL_20);
        return this.createQueryDetails(queryId, q);
    }

    private QueryDetails createQueryDetails(String queryId, com.hp.hpl.jena.query.Query query) {
        if (!this.init) {
            throw new IllegalStateException("Component not initialized: " + this.getClass().getSimpleName());
        }
        this.logger.info("Analysing query with ID " + queryId);
        QueryDetails qd = new QueryDetails();
        qd.setQueryId(queryId);
        qd.setWindowTime(query.getWindowTime());
        if (this.dcepManagmentApi.getRegisteredEventPatterns().containsKey(queryId)) {
            throw new IllegalArgumentException("Query ID is alread used: " + queryId);
        }
        StreamIdCollector streamIdCollector = new StreamIdCollector();
        streamIdCollector.getStreamIds(query, qd);
        return qd;
    }

    public String getRegisteredQuery(String queryId) {
        if (!this.init) {
            throw new IllegalStateException("Component not initialized: " + this.getClass().getSimpleName());
        }
        return this.dcepManagmentApi.getRegisteredEventPattern(queryId).getEpSparqlQuery();
    }

    public List<Query> getRegisteredQueries() {
        if (!this.init) {
            throw new IllegalStateException("Component not initialized: " + this.getClass().getSimpleName());
        }
        ArrayList<Query> results = new ArrayList<Query>();
        Map queries = this.dcepManagmentApi.getRegisteredEventPatterns();
        for (String queryId : queries.keySet()) {
            Query query = new Query();
            query.id = queryId;
            query.content = ((EpSparqlQuery)queries.get(queries)).getEpSparqlQuery();
            results.add(query);
        }
        return results;
    }
}

